<?php

namespace AvengersMG\MGCms2019\App\Cms\Components\Restaurants;

use Astrotomic\Translatable\Translatable;
use AvengersMG\MGCms2019\App\Cms\Components\Restaurants\RestaurantTranslation;
use AvengersMG\MGCms2019\App\Cms\Pages\Page;
use Illuminate\Database\Eloquent\Model;

class Restaurant extends Model
{
    use Translatable;

    protected $fillable = ['page_id', 'open_hours'];
    protected $translatedAttributes = ['name', 'menus', 'title','subtitle', 'body', 'open', 'close'];

    public function services()
    {
        return $this->belongsToMany(Service::class);
    }

    /**
     * Método para establecer la relación entre el restaurante y el objeto Page
     * @return BelongsTo Relación de pertenencia
     */
    public function page()
    {
        return $this->belongsTo(Page::class);
    }
}
