<?php

namespace AvengersMG\MGCms2019\App\Cms\Components\Restaurants\Policies;

use AvengersMG\MGCms2019\App\Cms\Components\Restaurants\Service;
use AvengersMG\MGCms2019\App\Cms\Users\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class ServicePolicy
{
    use HandlesAuthorization;

    /**
     * Create a new policy instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Determine whether the user can view the service list.
     *
     * @param  User $user
     * @return mixed
     */
    public function viewAny(User $user)
    {
        /* Permitir si puede listar los servicios */
        return $user->can('listar_servicios');
    }

    /**
     * Determine whether the user can view the service.
     *
     * @param  User $user
     * @param  Service $service
     * @return mixed
     */
    public function view(User $user, Service $service)
    {
        /* Permitir si puede ver todos los servicios */
        return $user->can('ver_servicios');
    }

    /**
     * Determine whether the user can create services.
     *
     * @param  User $user
     * @return mixed
     */
    public function create(User $user)
    {
        /* Permitir si puede crear servicios */
        return $user->can('crear_servicios');
    }

    /**
     * Determine whether the user can update the service.
     *
     * @param  User $user
     * @param  Service $service
     * @return mixed
     */
    public function update(User $user, Service $service)
    {
        /* Permitir si puede actualizar los servicios */
        return $user->can('editar_servicios');
    }

    /**
     * Determine whether the user can delete the service.
     *
     * @param  User $user
     * @param  Service $service
     * @return mixed
     */
    public function delete(User $user, Service $service)
    {
        /* Permitir si puede eliminar los servicios */
        return $user->can('eliminar_servicios');
    }
}
