<?php

namespace AvengersMG\MGCms2019\App\Cms\Components\Galleries\Requests;

use AvengersMG\MGCms2019\App\Cms\Components\Galleries\Interfaces\FeaturableInterface;
use Illuminate\Foundation\Http\FormRequest;

class UpdateGalleryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'images' => [
                'sometimes',
                'array',
            ],
            'images.*' => [
                'numeric',
                'exists:mediafiles,id',
            ],
            'name' => [
                'required',
            ],
            'gallery_features' => [
                'sometimes',
                'array',
            ],
            'gallery_features.*' => [
                'string',
                function ($attribute, $value, $fail) {
                    if (!is_a($value, FeaturableInterface::class, true)) {
                        $fail("Una clase especificada no es una fuente de imágenes válida: {$value}");
                    }
                },
            ],
        ];
    }
}
