<?php
namespace AvengersMG\MGCms2019\App\Cms\Components\Galleries\Repositories;

use \Exception;
use AvengersMG\MGCms2019\App\Cms\BaseRepository\BaseRepository;
use AvengersMG\MGCms2019\App\Cms\Components\Galleries\Gallery;
use AvengersMG\MGCms2019\App\Cms\Components\Galleries\GalleryFeature;
use AvengersMG\MGCms2019\App\Cms\Components\Galleries\Item;
use AvengersMG\MGCms2019\App\Cms\Pages\Page;
use Carbon\Carbon;
use Illuminate\Support\Arr;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;

class ItemRepository extends BaseRepository implements ItemInterface
{
    public function __construct()
    {
        parent::__construct(Item::class);
    }

    /**
     * Método público para recuperar todos los ítems que estén asignados a
     * galerías pertenecientes a páginas que pertenecen a un sitio.
     *
     * @param  mixed               $galleries ID, arreglo o colección de IDs,
     *                                        galería, arreglo o colección
     *                                        de galerías
     * @return Collection|Item[]              Los ítems
     */
    public function getByGallery($galleries)
    {
        /* Ajustar la variable de entrada */
        switch(gettype($galleries)){
            case 'integer':
                $galleries = [$galleries];
                break;
            case 'object':
                if ($galleries instanceof Collection) {
                    if ($galleries->get(0) instanceof Gallery) {
                        $galleries = $galleries->pluck('id')->all();
                    } else {
                        $galleries = $galleries->all();
                    }
                } else if($galleries instanceof Gallery) {
                    $galleries = [$galleries->id];
                }
                break;
            case 'array':
                if ($galleries[0] instanceof Gallery) {
                    $galleries = array_map(
                        function ($gallery) {
                            return $gallery->id;
                        },
                        $galleries
                    );
                }
                break;
            default:
                break;
        }

        try {
            /* Retornar los ítems */
            return Item::whereHas('gallery', function ($query) use ($galleries) {
                $query->whereIn('id', $galleries);
            })->get();
        } catch (Exception $e) {
            return collect();
        }
    }

    /**
     * Método público para recuperar todos los ítems que estén asignados a
     * galerías pertenecientes a páginas que pertenecen a un sitio.
     *
     * @param  Site               $site Objeto de sitio
     * @return Collection|Item[]        Los ítems
     */
    public function getBySite(Site $site)
    {
        return Item::whereHas('gallery.page.site', function ($query) use ($site) {
            $query->where('id', $site->id);
        })->get();
    }
}
