<?php

namespace AvengersMG\MGCms2019\App\Cms\Components\Galleries;

use AvengersMG\MGCms2019\App\Cms\Components\Galleries\Gallery;
use AvengersMG\MGCms2019\App\Cms\Mediafiles\Mediafile;
use Illuminate\Database\Eloquent\Model;

class Item extends Model
{
    protected $fillable = ['gallery_id', 'mediafile_id', 'priority', 'featurable_type', 'featurable_id', 'is_proprity_fixed'];

    /**
     * Método público que establece la relación entre el ítem y el mediafile
     *
     * @return BelongsTo Relación de pertenencia
     */
    public function mediafile()
    {
        return $this->belongsTo(Mediafile::class);
    }

    /**
     * Método público que establece la relación entre el ítem y la galería
     *
     * @return BelongsTo Relación de pertenencia
     */
    public function gallery()
    {
        return $this->belongsTo(Gallery::class);
    }

    /**
     * Método público que establece la relación entre el ítem y el objeto
     * que representa
     *
     * @return MorphTo Relación (Llamado como propiedad: Model|null)
     */
    public function featurable()
    {
        return $this->morphTo();
    }
}
