<?php

namespace AvengersMG\MGCms2019\App\Cms\Components\Galleries\Interfaces;

use AvengersMG\MGCms2019\App\Cms\Sites\Site;

interface FeaturableInterface
{
  /**
   * Método estático público para recuperar consulta sobre las páginas
   * de todos los sitios que tienen fuente de imágenes establecida.
   *
   * @return Builder         Consulta filtrada
   */
    public static function ownerPagesQuery();

    /**
     * Método público, que sirve como accesor, para recuperar la
     * fecha de inicio.
     *
     * @return string           Fecha formateada
     */
    public function getFeaturableStartDateAttribute();

    /**
     * Método público, que sirve como accesor, para recuperar la
     * fecha de fin.
     *
     * @return string           Fecha formateada
     */
    public function getFeaturableEndDateAttribute();

    /**
     * Método estático público para recuperar el formato en que las fechas
     * son retornadas por el objeto.
     *
     * @return string           Formato de fecha
     */
    public static function getFeaturableDateFormat();

    /**
     * Método público, que sirve como accesor, para recuperar el valor de
     * permanencia del objeto.
     *
     * @return boolean          Bandera de permanencia
     */
    public function getFeaturablePermanentAttribute();

    /**
     * Método público estático para recuperar el nombre del método que describe
     * la relación que la fuente de imágenes tiene con la página.
     *
     * El resultado debe ser un método que está definido como relación en el
     * modelo Page.
     *
     * @return string Nombre del método
     */
    public static function getFeaturableRelationshipMethod();
}
