<?php

namespace AvengersMG\MGCms2019\App\Cms\Components\Galleries;

use Astrotomic\Translatable\Translatable;
use AvengersMG\MGCms2019\App\Cms\Components\Galleries\GalleryFeature;
use AvengersMG\MGCms2019\App\Cms\Components\Positions\Position;
use AvengersMG\MGCms2019\App\Cms\Mediafiles\Mediafile;
use AvengersMG\MGCms2019\App\Cms\Pages\Page;
use Illuminate\Database\Eloquent\Model;

class Gallery extends Model
{
    protected $fillable = ['page_id', 'name', 'name_es', 'is_mobile', 'priority'];

    public function items()
    {
        return $this->hasMany(Item::class);
    }

    public function page()
    {
        return $this->belongsTo(Page::class);
    }

    /**
     * Método para establecer la relación entre la galería y
     * los objetos GalleryFeature
     *
     * @return HasMany Relación de propiedad
     */
    public function features()
    {
        return $this->hasMany(GalleryFeature::class);
    }
}
