<?php

namespace AvengersMG\MGCms2019\App\Cms\Components\Cards\Repositories;

use AvengersMG\MGCms2019\App\Cms\BaseRepository\BaseRepository;
use AvengersMG\MGCms2019\App\Cms\Components\Cards\Card;
use Illuminate\Support\Str;

class CardRepository extends BaseRepository implements CardInterface
{
    public function __construct()
    {
        parent::__construct(Card::class);
    }

    public function create($data)
    {
        app()->setLocale($data['locale']);

        if ($data['title']) {
            $data['slug'] = Str::slug($data['title'], '-');
        } else {
            $data['slug'] = chr(rand(65, 90)) . '-' . chr(rand(65, 90)) . '-' . chr(rand(65, 90)) . '-' . chr(rand(65, 90)) . '-' . chr(rand(65, 90));
        }

        $data['slug'] = strtolower($data['slug']);
        $card = call_user_func("{$this->model}::create", $data);
        return $card;
    }

    public function update($data, $model = '')
    {
        app()->setLocale($data['locale']);

        if ($data['title']) {
            $data['slug'] = Str::slug($data['title'], '-');
        } else {
            $data['slug'] = strtolower(chr(rand(65, 90)) . '-' . chr(rand(65, 90)) . '-' . chr(rand(65, 90)) . '-' . chr(rand(65, 90)) . '-' . chr(rand(65, 90)));
        }

        $card = $this->findOrFail($data['id']);
        $card->update($data);
        return $card;
    }

    /**
     * Método público para el cambio de la proporidad
     * de los modelos Card de acuerdo con la información provista
     *
     * 2019-06-19: Descodificación de JSON delegado a usuario del recurso
     *
     * @param  array[] $cards Arreglo asociativo con información de objetos
     * @return void
     */
    public function updatePriority($cards)
    {
        foreach ($cards as $priority => $card) {
            $card = Card::find($card['id']);
            $card->priority = $priority;
            $card->save();
        }
    }

    public function mediaFile()
    {
        return call_user_func("{$this->model}::mediafiles");
    }
}
