<?php

namespace AvengersMG\MGCms2019\App\Cms\Components\Cards;

use Astrotomic\Translatable\Translatable;
use AvengersMG\MGCms2019\App\Cms\Mediafiles\Mediafile;
use AvengersMG\MGCms2019\App\Cms\Components\Cards\CardTranslation;
use AvengersMG\MGCms2019\App\Cms\Components\Positions\Position;
use AvengersMG\MGCms2019\App\Cms\Pages\Page;
use Illuminate\Database\Eloquent\Model;

class Card extends Model
{
    use Translatable;

    /*
        ADVERTENCIA: El atributo "image" es un dato abierto a inconsistencias,
        porque es posible cambiar el nombre y ruta en un objeto Mediafile y la
        imagen no será encontrada. Sugerencia: remover campo en tabla y crear
        un campo numérico `mediafile_id` para establecer una relación 1-a-1 al
        objeto Mediafile
     */

    public $translatedAttributes = ['title', 'title_two', 'body', 'image', 'slug', 'link'];
    protected $fillable = ['page_id', 'priority'];

    /*
      2019-06-27: Método retirado. La página asociada contiene los mediafiles

    public function mediafiles()
    {
        return $this->morphMany(Mediafile::class, 'mediafilable');
    }
    */

    public function positions()
    {
        return $this->hasMany(Position::class);
    }

    public function page()
    {
        return $this->belongsTo(Page::class);
    }
}
