<?php

namespace AvengersMG\MGCms2019\App\Cms\Banners\Repositories;

use AvengersMG\MGCms2019\App\Cms\BaseRepository\BaseRepository;
use AvengersMG\MGCms2019\App\Cms\Banners\Banner;
use AvengersMG\MGCms2019\App\Cms\Pages\Page;

class BannerRepository extends BaseRepository implements BannerInterface
{
    /**
     * [__construct]
     */
    public function __construct()
    {
        /* usa el modelo como padre de la clase */
        parent::__construct(Banner::class);
    }

        /**
     * @param $img
     * recibe como parametro el un type file
     */

    public function uploadImage($img)
    {
        $name = explode('.', $img->getClientOriginalName());
        array_pop($name);
        $name = $this->getName($name);
        $ext = $img->getClientOriginalExtension();
        $full_name = $name.'.'.$ext;

        $path = $img->storeAs('mediafiles/banners/'.date('Y').'/'.date('m'), $full_name, 'MGCms2019');

        return $path;
    }

    public function getName($array)
    {
        $name = '';
        foreach ($array as $item) {
            $name = $name.$item;
        }

        return $name;
    }

    /**
     * Método público para la recuperación de páginas de acuerdo con un lenguaje
     *
     * Creado para mantener código con principio DRY
     *
     * @param  null|string $lang Identificador de localización. null representa
     *                           el lenguaje establecido en la aplicación
     * @return string[]          ['id' => 'nombre de la página (dominio del sitio)']
     */
    public function pageNamesByLanguage($lang = null)
    {
        /* Establecer valor en caso de no haberlo especificado */
        $lang = is_null($lang)
            ? app()->getLocale()
            : $lang;

        return Page::translatedIn($lang)->with(['translations', 'site'])->get()->mapWithKeys(function($value) {
            return [
                "{$value->id}" => "{$value->name} ({$value->site->domain})",
            ];
        })->all();
    }
}
