<?php

namespace AvengersMG\MGCms2019\App\Cms\Banners\Policies;

use AvengersMG\MGCms2019\App\Cms\Banners\Banner;
use AvengersMG\MGCms2019\App\Cms\Users\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class BannerPolicy
{
    use HandlesAuthorization;

    /**
     * Create a new policy instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Determine whether the user can view the banner list.
     *
     * @param  User $user
     * @return mixed
     */
    public function viewAny(User $user)
    {
        /* Permitir si puede listar todos los banners */
        return $user->can('listar_banners');
    }

    /**
     * Determine whether the user can view the banner.
     *
     * @param  User $user
     * @param  Banner $banner
     * @return mixed
     */
    public function view(User $user, Banner $banner)
    {
        /* Permitir si puede ver todos los banners */
        return $user->can('ver_banners');
    }

    /**
     * Determine whether the user can create banners.
     *
     * @param  User $user
     * @return mixed
     */
    public function create(User $user)
    {
        /* Permitir si puede crear banners */
        return $user->can('crear_banners');
    }

    /**
     * Determine whether the user can update the banner.
     *
     * @param  User $user
     * @param  Banner $banner
     * @return mixed
     */
    public function update(User $user, Banner $banner)
    {
        /* Permitir si puede actualizar todos los banners */
        return $user->can('editar_banners');
    }

    /**
     * Determine whether the user can delete the banner.
     *
     * @param  User $user
     * @param  Banner $banner
     * @return mixed
     */
    public function delete(User $user, Banner $banner)
    {
        /* Permitir si puede eliminar todos los banners */
        return $user->can('eliminar_banners');
    }
}
