<?php

namespace AvengersMG\MGCms2019\App\Cms\Banners;

use Astrotomic\Translatable\Translatable;
use AvengersMG\MGCms2019\App\Cms\Pages\Page;
use Illuminate\Database\Eloquent\Model;

class Banner extends Model
{
    use Translatable;

    public $translatedAttributes = ['banner_id', 'name', 'caption', 'body', 'page_id', 'url_custom', 'img', 'locale', ''];
    protected $fillable = ['position', 'type', 'priority', 'countdown', 'duration', 'start_date', 'end_date', 'active'];

    public function page()
    {
        return $this->belongsTo(Page::class);
    }

}
