<?php

namespace AvengersMG\MGCms2019\App\Cms\Availabilities\Policies;

use AvengersMG\MGCms2019\App\Cms\Availabilities\Availability;
use AvengersMG\MGCms2019\App\Cms\Users\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class AvailabilityPolicy
{
    use HandlesAuthorization;

    /**
     * Create a new policy instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Determine whether the user can view the form list.
     *
     * @param  User $user
     * @return mixed
     */
    public function viewAny(User $user)
    {
        /* Permitir si puede listar todas las disponibilidades */
        return $user->can('listar_disponibilidades');
    }


    /**
     * Determine whether the user can rebuild all the forms.
     *
     * @param  User $user
     * @return mixed
     */
    public function updateAll(User $user)
    {
        /* Permitir si puede actualizar todas las disponibilidades */
        return $user->can('editar_disponibilidades');
    }
}
