<?php

namespace AvengersMG\MGCms2019\App\Cms\Availabilities;

use AvengersMG\MGCms2019\App\Cms\Users\User;
use Illuminate\Database\Eloquent\Model;

class AvailabilitiesLogEntry extends Model
{
    protected $table = "availabilities_log_entries";
    protected $fillable = ['user_id', 'file_name', 'file_size', 'file_content_type'];
    protected $dates = [
        'created_at',
    ];
    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    /* Método para funciones de booteo */
    public static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->created_at = $model->freshTimestamp();
        });
    }

    /**
     * Método para definir la relación entre la entrada de registro y su usuario
     * @return BelongsTo Relación de pertenencia
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
