<?php

namespace AvengersMG\MGCms2019\App\Cms\Apis\Interfaces;

use Illuminate\Support\Collection;

/**
 * Contrato (interfaz) que todas las APIs deben de seguir para ser usadas por
 * el adaptador. Refiérase a los comentarios de cada método para información
 * sobre el formato y estructura de cada uno.
 *
 * @var interface
 */
interface ApiInterface
{

    /**
     * Método público para establecer todas las credenciales que la API usa
     * @param array      $credentials Las credenciales
     * @return void
     */
    public function setCredentials(array $credentials);

    /**
     * Método público para establecer la fecha de llegada
     * @param string      $arrivalDate Fecha de llegada
     * @param string|null $format      Formato en que la fecha está establecida
     * @return void
     */
    public function setArrivalDate(string $arrivalDate, $format = null);

    /**
     * Método público para establecer la fecha de salida
     * @param string      $arrivalDate Fecha de salida
     * @param string|null $format      Formato en que la fecha está establecida
     * @return void
     */
    public function setDepartureDate(string $departureDate, $format = null);

    /**
     * Método público para recuperar la fecha de llegada
     * @param string|null $format      Formato en que la fecha está establecida
     * @return string
     */
    public function getArrivalDate($format = null);

    /**
     * Método público para recuperar la fecha de salida
     * @param string|null $format      Formato en que la fecha está establecida
     * @return string
     */
    public function getDepartureDate($format = null);

    /**
     * Método público para establecer el lenguaje
     * @param string      $language    Identificador de localización
     * @return void
     */
    public function setLanguage(string $language);

    /**
     * Método público para recuperar el lenguaje
     * @return string
     */
    public function getLanguage();

    /**
     * Método público para establecer la moneda
     * @param string      $currency    Identificador de moneda
     * @return void
     */
    public function setCurrency(string $currency);

    /**
     * Método público para recuperar la ocupación más grande solicitada
     * @return stdClass            Objeto con propiedades. (null = sin límite)
     *                                 stdClass(
     *                                     total => (int),
     *                                     adults => (int|null),
     *                                     children => (int|null)
     *                                 )
     */
    public function getLargestOccupancy();

    /**
     * Método público para establecer la información de habitaciones
     * @param array      $roomsData    Arreglo con las definiciones de las
     *                                 habitaciones solicitadas en el
     *                                 siguiente formato ("childAges" es
     *                                 opcional en todos los cuartos):
     *                                      [
     *                                          [
     *                                              'adults' => (int),
     *                                              'childAges' => [
     *                                                  (int),
     *                                                  ...
     *                                              ],
     *                                          ],
     *                                          ...
     *                                      ]
     * @return void
     */
    public function setRoomsData(array $roomsData);

    /**
     * Método público para obtener la cuenta de habitaciones solicitadas
     * @return int Cantidad de habitaciones
     */
    public function getRoomsCount();

    /**
     * Método público para recuperar los datos crudos leídos del API, para evitar
     * una nueva llamada
     * @return mixed Los datos recuperados
     */
    public function getRemoteCachedData();

    /**
     * Método público para recuperar últimos resultados,
     * para evitar una nueva llamada
     * @return Collection Los datos recuperados
     */
    public function getCachedData();

    /**
     * Método público para retornar la información que el
     * adaptador retornará
     * @return Collection|stdClass[] Colección de objetos planos
     *                               con información normalizada de API:
     *                                  collect(
     *                                      stdClass(
     *                                         apiId => string,
     *                                         totalAmount => float,
     *                                         deepLink => string,
     *                                         ratePlans =>  collect(
     *                                            stdClass(
     *                                                totalAmount => float,
     *                                                averageRateWithTax => float,
     *                                                dailyRates => collect(
     *                                                    stdClass(
     *                                                        stayDate => Carbon,
     *                                                        totalAmount => float,
     *                                                        prePromotionalRate => float,
     *                                                        promotionMessage => float
     *                                                    ),
     *                                                    ...
     *                                                )
     *                                            ),
     *                                            ...
     *                                         )
     *                                      ),
     *                                      ...
     *                                  )
     *
     *
     */
    public function getRemoteAvailabilityData();

    /**
     * Método público para establecer toda la configuración que la API necesita
     *
     * @param array $configData Datos crudos a establecer
     * @return void
     */
    public function setConfig(array $configData);

    /**
     * Método público para recuperar la última excepción generada.
     * @return Exception
     */
    public function getLastException();

    /**
     * Método público para recuperar la cantidad total de adultos en la reservación
     * @return int
     */
    public function getTotalAdultCount();

    /**
     * Método público para recuperar la cantidad total de menores en la reservación
     * @return int
     */
    public function getTotalChildrenCount();
}
