<?php
namespace AvengersMG\MGCms2019\App\Cms\Apis;

use AvengersMG\MGCms2019\App\Cms\Availabilities\Availability;

class Calendar
{
    /** @var string Fecha de inicio en formato YYYY-MM-DD */
    protected $startDay;

    /** @var string Fecha de fin en formato YYYY-MM-DD */
    protected $endDay;

    /** @var string Identificador de lenguage (Ej.: "en", "es"...) */
    protected $language;

    /** @var Collection|array[] Identificadores de días de la semana */
    protected $daysString;

    /**
     * Constructor de clase
     * @param string $startDay Fecha de inicio en formato YYYY-MM-DD
     * @param string $endDay   Fecha de fin en formato YYYY-MM-DD
     * @param string $language Identificador de lenguage (Ej.: "en", "es"...)
     */
    public function __construct($startDay, $endDay, $language = 'en')
    {
        $this->startDay = $startDay;
        $this->endDay = $endDay;
        $this->language = $language;

        /* Poblar nombres de días */
        $this->populateDaysString();
    }

    public function createWeek()
    {
        $timestamp = strtotime($this->startDay);
        $days = array();
        for ($i = 0; $i < 7; $i++) {
            $days[] = $this->daysString->get($this->language)->get((int) date('w', $timestamp));
            $timestamp = strtotime('+1 day', $timestamp);
        }
        return $days;
    }

    public function createDays()
    {
        $numbers = array();
        for ($date = strtotime("$this->startDay"); $date < strtotime($this->endDay); $date = strtotime("+1 day", $date)) {
            $numbers[] = date("d", $date);
        }

        $numbers = array_chunk($numbers, 7);
        array_walk($numbers, function ($var, $key) use (&$numbers) {
            if (count($var) < 7) {
                for ($i= count($var); $i <7 ; $i++) {
                    $numbers[$key][] = null;
                }
            }
        });

        return $numbers;
    }

    /**
     * Método privado para poblar la propiedad privada $this->daysString
     * @return void
     */
    private function populateDaysString()
    {
        $this->daysString = collect([
            'es' => collect([
                'Dom',
                'Lun',
                'Mar',
                'Mié',
                'Jue',
                'Vie',
                'Sáb',
            ]),
            'en' => collect([
                'Sun',
                'Mon',
                'Tue',
                'Wed',
                'Thu',
                'Fri',
                'Sat',
            ]),
        ]);
    }
}
