<?php

namespace AvengersMG\MGCms2019\App\Cms\ApiConsumers\Requests;

use AvengersMG\MGCms2019\App\Cms\ApiConsumers\ApiConsumer;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateApiConsumerRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $data = $this->request->all();
        $apiConsumer = ApiConsumer::find($data['id']);
        return [
            'username' => ['required', Rule::unique('api_consumers', 'username')->ignore($apiConsumer->id)],
            'password' => 'nullable|min:6|confirmed',
            'email' => ['required', Rule::unique('api_consumers', 'email')->ignore($apiConsumer->id)],
            'sites' => 'sometimes|array',
            'sites.*' => 'required_with:sites|exists:sites,id',
        ];
    }
}
