<?php

namespace AvengersMG\MGCms2019\App\Cms\ApiConsumers\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreApiConsumerRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'username' => 'required|unique:api_consumers,username',
            'password' => 'required|min:6|confirmed',
            'email' => 'unique:api_consumers,email',
            'sites' => 'sometimes|array',
            'sites.*' => 'required|exists:sites,id',
        ];
    }
}
