<?php

namespace AvengersMG\MGCms2019\App\Cms\ApiConsumers\Repositories;

use AvengersMG\MGCms2019\App\Cms\ApiConsumers\ApiConsumer;
use AvengersMG\MGCms2019\App\Cms\ApiConsumers\Repositories\ApiConsumerInterface;
use AvengersMG\MGCms2019\App\Cms\BaseRepository\BaseRepository;

class ApiConsumerRepository extends BaseRepository implements ApiConsumerInterface
{
    public function __construct()
    {
        parent::__construct(ApiConsumer::class);
    }

    /**
     * @param  mixed[]          $data
     * @param  ApiConsumer|null $apiConsumer is a instance of ApiConsumer Model
     * @return ApiConsumer
     */
    public function update($data, $apiConsumer = null)
    {
        if (!$data['password']) {
            unset($data['password']);
        }

        $apiConsumer->update($data);

        return $apiConsumer;
    }
}
