<?php

namespace AvengersMG\MGCms2019\App\Cms\ApiConsumers\Policies;

use AvengersMG\MGCms2019\App\Cms\ApiConsumers\ApiConsumer;
use AvengersMG\MGCms2019\App\Cms\Users\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class ApiConsumerPolicy
{
    use HandlesAuthorization;

    /**
     * Create a new policy instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Determine whether the user can view the API consumer list.
     *
     * @param  ApiConsumer $apiConsumer
     * @return mixed
     */
    public function viewAny(User $user)
    {
        /* Permitir si puede listar los consumidores de API */
        return $user->can('listar_consumidores_de_api');
    }

    /**
     * Determine whether the user can view the API consumer.
     *
     * @param  User $user
     * @param  ApiConsumer $apiConsumer
     * @return mixed
     */
    public function view(User $user, ApiConsumer $apiConsumer)
    {
        /* Permitir si puede ver todos los consumidores de API o si es su propio perfil */
        return $user->can('ver_consumidores_de_api');
    }

    /**
     * Determine whether the user can create users.
     *
     * @param  User $user
     * @return mixed
     */
    public function create(User $user)
    {
        /* Permitir si puede crear usuarios */
        return $user->can('crear_consumidores_de_api');
    }

    /**
     * Determine whether the user can update the API consumer.
     *
     * @param  User $user
     * @param  ApiConsumer $apiConsumer
     * @return mixed
     */
    public function update(User $user, ApiConsumer $apiConsumer)
    {
        /* Permitir si puede actualizar los consumidores de API */
        return $user->can('editar_consumidores_de_api');
    }

    /**
     * Determine whether the user can delete the API consumer.
     *
     * @param  User $user
     * @param  ApiConsumer $apiConsumer
     * @return mixed
     */
    public function delete(User $user, ApiConsumer $apiConsumer)
    {
        /* Permitir si puede eliminar los consumidores de API  */
        return $user->can('eliminar_consumidores_de_api');
    }
}
