<?php

namespace AvengersMG\MGCms2019\App\Cms\ApiConsumers;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Passport\HasApiTokens;

use Illuminate\Support\Str;

class ApiConsumer extends Authenticatable
{
    use Notifiable, HasApiTokens;

    protected $guard_name = 'api';

    /**
     * Find the user instance for the given username.
     *
     * @param  string  $username
     * @return static
     */
    public function findForPassport($username)
    {
        return $this->where('username', $username)->first();
    }

    public function setUsernameAttribute($value)
    {
        $this->attributes['username'] = Str::slug(mb_strtolower($value), '');
    }

    public function setPasswordAttribute($value)
    {
        $this->attributes['password'] = bcrypt($value);
    }
}
