<?php

namespace AvengersMG\MGCms2019\App\Cms\Accommodations\Rooms\Request;

use AvengersMG\MGCms2019\App\Cms\Accommodations\Room;
use AvengersMG\MGCms2019\App\Cms\Accommodations\RoomApiCode;
use AvengersMG\MGCms2019\App\Cms\Accommodations\Rooms\Request\RoomRequest;
use Illuminate\Support\Str;
use Illuminate\Validation\Rule;

class UpdateRoomRequest extends RoomRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $prefix = RoomApiCode::fieldPrefix() . '_';

        /* Variable de contexto */
        $self = $this;

        /** @var string[] Códigos de API en sistema */
        $api_codes = RoomApiCode::pluck('api_code');

        /** @var mixed[] Reglas originales */
        $original_rules = parent::rules();

        /* Sobrescribir reglas de códigos de API */
        return array_merge(
            $original_rules,
            [
                'api_id.*' => [
                    'sometimes',
                    function ($attribute, $value, $fail) use ($prefix, $api_codes, $self) {
                        /** Recuperar la habitación inyectada desde sobrecarga */
                        $room = $self->route()->room;

                        if (empty($room)) {
                            $fail("ID de habitación no válido.");
                        } else {
                            /** @var string Llave original desde el formulario */
                            $index = Str::after($attribute, 'api_id.');

                            if (Str::startsWith($index, $prefix)) {
                                /** @var string ID de código de API */
                                $id = Str::after($index, $prefix);

                                if ($room->apiCodes()->where('id', $id)->count() < 1) {
                                    $fail("ID de códido de API no asociado a la habitación.");
                                }
                            } else if ($api_codes->contains($value)) {
                                /*
                                    Si la llave no es reconocido como un identificador,
                                    busca en todos los códigos...

                                    Pero si la cuenta de modelos que usan este código es mayor a 0,
                                    entonces ya está usado.
                                */
                                $fail("El código de API {$value} ya está usado.");
                            }
                        }
                    },
                ]
            ]
        );
    }
}
