<?php

namespace AvengersMG\MGCms2019\App\Cms\Accommodations\Rooms\Request;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class RoomRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'locale' => [
                'required',
                Rule::in(app()->make('translatable.locales')->all()),
            ],
            'name' => 'required',
            'api_id' => 'sometimes|array',
            'api_id.*' => 'sometimes|distinct|unique:room_api_codes,api_code',
            'capacity_room' => 'required|integer',
            'adults_room' => 'required|integer',
            'childrens_room' => 'required|integer',
            'capacity' => 'required|array',
            'adults' => 'required|array',
            'childrens' => 'required|array',
            'beds'  => 'required',
            'bathrooms' => 'required',
            'floor_area' => 'required',
        ];
    }
}
