<?php

namespace AvengersMG\MGCms2019\App\Cms\Accommodations;

use AvengersMG\MGCms2019\App\Cms\Accommodations\RoomDataOverride;
use Illuminate\Database\Eloquent\Model;

class RoomApiCodeTranslation extends Model
{
    protected $fillable = ["room_api_code_id", "locale", "thumbnail_mediafile_id"];

    /**
     * Método público para recuperar los datos que sobrescriben las propiedades de la página
     * de acuerdo con el código de API
     * 
     * @return HasMany  Relación de pertenencia
     */
    public function overrides()
    {
        return $this->hasMany(RoomDataOverride::class, 'room_api_code_translation_id');
    }
}