<?php

namespace AvengersMG\MGCms2019\App\Cms\Accommodations;

use Astrotomic\Translatable\Translatable;
use AvengersMG\MGCms2019\App\Cms\Accommodations\Room;
use Illuminate\Database\Eloquent\Model;


class RoomApiCode extends Model
{
    use Translatable;

    protected $fillable = ["room_id", "api_code",];
    public $translatedAttributes = ["locale", "thumbnail_mediafile_id"];

    protected static $fieldPrefix = "code";

    /**
     * Crea la relación de muchos a uno entre el modelo y la habitación
     * 
     * @return BelongsTo La relación
     */
    public function room()
    {
        return $this->belongsTo(Room::class, 'room_id');
    }

    /**
     * Método estático para recuperar el prefijo que deben seguir los nombres de los campos
     */
    public static function fieldPrefix()
    {
        return static::$fieldPrefix;
    }    
}