<?php

namespace AvengersMG\MGCms2019\App\Cms\Accommodations\Policies;

use AvengersMG\MGCms2019\App\Cms\Accommodations\Category;
use AvengersMG\MGCms2019\App\Cms\Users\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class CategoryPolicy
{
    use HandlesAuthorization;

    /**
     * Create a new policy instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Determine whether the user can view the category list.
     *
     * @param  User $user
     * @return mixed
     */
    public function viewAny(User $user)
    {
        /* Permitir si puede listar las categorías */
        return $user->can('listar_categorias');
    }

    /**
     * Determine whether the user can view the category.
     *
     * @param  User $user
     * @param  Category $category
     * @return mixed
     */
    public function view(User $user, Category $category)
    {
        /* Permitir si puede ver todas las categorías */
        return $user->can('ver_categorias');
    }

    /**
     * Determine whether the user can create categories.
     *
     * @param  User $user
     * @return mixed
     */
    public function create(User $user)
    {
        /* Permitir si puede crear categorías */
        return $user->can('crear_categorias');
    }

    /**
     * Determine whether the user can update the category.
     *
     * @param  User $user
     * @param  Category $category
     * @return mixed
     */
    public function update(User $user, Category $category)
    {
        /* Permitir si puede actualizar las categorías */
        return $user->can('editar_categorias');
    }

    /**
     * Determine whether the user can delete the category.
     *
     * @param  User $user
     * @param  Category $category
     * @return mixed
     */
    public function delete(User $user, Category $category)
    {
        /* Permitir si puede eliminar las categorías */
        return $user->can('eliminar_categorias');
    }
}
