<?php

namespace AvengersMG\MGCms2019\App\Cms\Accommodations\Policies;

use AvengersMG\MGCms2019\App\Cms\Accommodations\Amenity;
use AvengersMG\MGCms2019\App\Cms\Users\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class AmenityPolicy
{
    use HandlesAuthorization;

    /**
     * Create a new policy instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Determine whether the user can view the amenity list.
     *
     * @param  User $user
     * @return mixed
     */
    public function viewAny(User $user)
    {
        /* Permitir si puede listar las amenidades */
        return $user->can('listar_amenidades');
    }

    /**
     * Determine whether the user can view the amenity.
     *
     * @param  User $user
     * @param  Amenity $amenity
     * @return mixed
     */
    public function view(User $user, Amenity $amenity)
    {
        /* Permitir si puede ver todas las amenidades */
        return $user->can('ver_amenidades');
    }

    /**
     * Determine whether the user can create amenities.
     *
     * @param  User $user
     * @return mixed
     */
    public function create(User $user)
    {
        /* Permitir si puede crear amenidades */
        return $user->can('crear_amenidades');
    }

    /**
     * Determine whether the user can update the amenity.
     *
     * @param  User $user
     * @param  Amenity $amenity
     * @return mixed
     */
    public function update(User $user, Amenity $amenity)
    {
        /* Permitir si puede actualizar las amenidades */
        return $user->can('editar_amenidades');
    }

    /**
     * Determine whether the user can delete the amenity.
     *
     * @param  User $user
     * @param  Amenity $amenity
     * @return mixed
     */
    public function delete(User $user, Amenity $amenity)
    {
        /* Permitir si puede eliminar las amenidades */
        return $user->can('eliminar_amenidades');
    }
}
