<!doctype html>
<html lang="<?php echo e(app()->getLocale()); ?>">

  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0" />
    <meta http-equiv="X-UA-Compatible" content="ie=edge" />
    <title>Gorilla CMS</title>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('cms/css/app.css')); ?>" />

    
    <link rel="apple-touch-icon-precomposed" sizes="57x57" href="<?php echo e(asset('cms/favicon/apple-touch-icon-57x57.png')); ?>" />
    <link rel="apple-touch-icon-precomposed" sizes="114x114" href="<?php echo e(asset('cms/favicon/apple-touch-icon-114x114.png')); ?>" />
    <link rel="apple-touch-icon-precomposed" sizes="72x72" href="<?php echo e(asset('cms/favicon/apple-touch-icon-72x72.png')); ?>" />
    <link rel="apple-touch-icon-precomposed" sizes="144x144" href="<?php echo e(asset('cms/favicon/apple-touch-icon-144x144.png')); ?>" />
    <link rel="apple-touch-icon-precomposed" sizes="60x60" href="<?php echo e(asset('cms/favicon/apple-touch-icon-60x60.png')); ?>" />
    <link rel="apple-touch-icon-precomposed" sizes="120x120" href="<?php echo e(asset('cms/favicon/apple-touch-icon-120x120.png')); ?>" />
    <link rel="apple-touch-icon-precomposed" sizes="76x76" href="<?php echo e(asset('cms/favicon/apple-touch-icon-76x76.png')); ?>" />
    <link rel="apple-touch-icon-precomposed" sizes="152x152" href="<?php echo e(asset('cms/favicon/apple-touch-icon-152x152.png')); ?>" />
    <link rel="icon" type="image/png" href="<?php echo e(asset('cms/favicon/favicon-96x96.png" sizes="96x96')); ?>" />
    <link rel="icon" type="image/png" href="<?php echo e(asset('cms/favicon/favicon.ico')); ?>" />
  </head>

  <body class="hold-transition skin-blue sidebar-mini">
    <div id="ajax-load">
      <img src="<?php echo e(asset('cms/images/ajaxload.gif')); ?>" alt="" />
    </div>
    <div class="wrapper">
    <?php echo $__env->make('MGCms2019::admin.partials.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('MGCms2019::admin.partials.sidenav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

      <div class="content-wrapper">

        <?php echo $__env->yieldContent('breadcrumbs'); ?> 
        <section class="content container-fluid">

          <?php echo $__env->yieldContent('content'); ?>

        </section>

      </div>
    <?php echo $__env->make('MGCms2019::admin.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
    <?php echo $__env->make('MGCms2019::admin.partials.sidebarControl', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>  <?php echo Form::open(['method' => 'delete', 'route' => ['roles.destroy', 'eliminado'], 'id' => 'delete-item']); ?> <?php echo Form::close(); ?>

    </div>
    <script src="<?php echo e(asset('cms/js/app.js')); ?>"></script>
    <script>
      $(document).ready(function(){
        tinymce.init({
          selector: '.wysiwyg',
          plugins: [
              'advlist autolink lists link image charmap print preview anchor',
              'searchreplace visualblocks code fullscreen',
              'insertdatetime media table paste code help wordcount '
          ],
          toolbar: "undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | table | fontsizeselect",
          skin_url: '<?php echo e(asset('cms/css/tinymce/skins/ui/oxide')); ?>',
          content_css: '<?php echo e(asset('cms/css/tinymce/skins/content/default/content.css')); ?>',
          valid_elements : '*[*]',
          
          <?php
            $is_page_set = isset($page);
          ?>
          <?php if($is_page_set || isset($site)): ?>
          relative_urls : false,
          remove_script_host : false,
          document_base_url : "<?php echo e(($is_page_set)? $page->site->base_url : $site->base_url); ?>",
          <?php endif; ?>
        });

        $('#reorder').on('click', function () {
          var mainNestable = $('.dd.model-main-tree');

          if ($(this).hasClass('active')) {
            let serialized = mainNestable.nestable('serialize');

            $.ajax({
              type: 'PUT',
              url: mainNestable.data('url'),
              data: JSON.stringify(serialized),
              contentType: 'json',
              headers: {
                'X-CSRF-Token': $('meta[name="csrf-token"]').attr('content')
              }
            }).done(function(){
              window.location.reload();
            });
          } else {
            $(this).addClass('active btn-warning').text('').append('<i class="fa fa-close"></i> Finalizar');
            $('.dd-list li div').css('cursor', 'move');
            mainNestable.nestable();
          }
        });

        $('#reorderOne').on('click', function () {
          var mainNestable = $('.dd.model-main-tree');

          if ($(this).hasClass('active')) {
            let serialized = mainNestable.nestable('serialize');

            $.ajax({
              type: 'PUT',
              url: mainNestable.data('url'),
              data: JSON.stringify(serialized),
              contentType: 'json',
              headers: {
                'X-CSRF-Token': $('meta[name="csrf-token"]').attr('content')
              }
            }).done(function(){
              window.location.reload();
            });
          } else {
            $(this).addClass('active btn-warning').text('').append('<i class="fa fa-close"></i> Finalizar');
            $('.dd-list li div').css('cursor', 'move');
            mainNestable.nestable({
              maxDepth:4
            });
          }
        });

        $('.dropdown-toggle').dropdown();
      });
    </script>
    <?php echo $__env->yieldPushContent('scripts'); ?>
  </body>
</html>
<?php /**PATH /home/inovationtravel/public_html/marivalvacationclub.com/vendor/avengersmg/mgcms_2019_pack/src/App/Providers/../../resources/views/admin/layouts/admin.blade.php ENDPATH**/ ?>