<?php
    $user = Auth::user();
    $current_site = AvengersMG\MGCms2019\App\Cms\Sites\Site::current();
    $is_admin = $user->hasRole('admin');
    $is_editor = $user->hasAnyRole(['editor', 'user']);
    $is_reservaciones = $user->hasRole('reservaciones');
?>
<aside class="main-sidebar">

    <!-- sidebar: style can be found in sidebar.less -->
    <section class="sidebar">

        <!-- Sidebar user panel (optional) -->
        <div class="user-panel">
            <div class="pull-left image">
                <img src="<?php echo e(asset('cms/images/gorilla-logo.jpg')); ?>" class="img-circle" alt="User Image">
            </div>
            <div class="pull-left info">
                <p><?php echo e(ucwords($user->name)); ?></p>
                <a href="#"><i class="fa fa-circle text-success"></i> Online</a>
            </div>
        </div>

        <!-- Sidebar Menu -->
        <ul class="sidebar-menu" data-widget="tree">
            <li class="active">
                <a href="<?php echo e(route('admin.index')); ?>"><i class="fas fa-chart-line"></i> Inicio</a>
            </li>
            <?php if($user->can('viewAny', AvengersMG\MGCms2019\App\Cms\Users\User::class) || $user->can('viewAny', Spatie\Permission\Models\Role::class) || $user->can('viewAny', Spatie\Permission\Models\Permission::class)): ?>
            <li class="treeview">
                <a href="#"><i class="fas fa-users"></i>
                    Usuarios
                    <span class="pull-right-container">
                        <i class="fa fa-angle-left pull-right"></i>
                    </span>
                </a>
                <ul class="treeview-menu">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('viewAny', AvengersMG\MGCms2019\App\Cms\Users\User::class)): ?>
                    <li><a href="<?php echo e(route('users.index')); ?>">Usuarios</a></li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('viewAny', Spatie\Permission\Models\Role::class)): ?>
                    <li><a href="<?php echo e(route('roles.index')); ?>">Roles</a></li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('viewAny', Spatie\Permission\Models\Permission::class)): ?>
                    <li><a href="<?php echo e(route('permissions.index')); ?>">Permisos</a></li>
                    <?php endif; ?>
                </ul>
            </li>
            <?php endif; ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('viewAny', AvengersMG\MGCms2019\App\Cms\Sites\Site::class)): ?>
            <li>
                <a href="<?php echo e(route('sites.index')); ?>"><i class="fa fa-laptop"></i> Sitio</a>
            </li>
            <?php endif; ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('viewAny', [AvengersMG\MGCms2019\App\Cms\Pages\Page::class, $current_site])): ?>
            <li>
                <a href="<?php echo e(route('pages.index-from-current')); ?>"><i class="fa fa-sitemap"></i> P&aacute;ginas</a>
            </li>
            <?php endif; ?>
            <?php if($user->can('viewAny', AvengersMG\MGCms2019\App\Cms\Accommodations\Amenity::class) || $user->can('viewAny', AvengersMG\MGCms2019\App\Cms\Accommodations\Category::class) || $user->can('viewAny', AvengersMG\MGCms2019\App\Cms\Components\Restaurants\Service::class)): ?>
            <li class="treeview">
                <a href="#"><i class="fa fa-th"></i>
                    Componentes
                    <span class="pull-right-container">
                        <i class="fa fa-angle-left pull-right"></i>
                    </span>
                </a>
                <ul class="treeview-menu">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('viewAny', AvengersMG\MGCms2019\App\Cms\Accommodations\Amenity::class)): ?>
                    <li><a href="<?php echo e(route('amenities.index')); ?>">Amenidades</a></li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('viewAny', AvengersMG\MGCms2019\App\Cms\Accommodations\Category::class)): ?>
                    <li><a href="<?php echo e(route('categories.index')); ?>">Categorías</a></li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('viewAny', AvengersMG\MGCms2019\App\Cms\Components\Restaurants\Service::class)): ?>
                    <li><a href="<?php echo e(route('services.index')); ?>">Servicios</a></li>
                    <?php endif; ?>
                </ul>
            </li>
            <?php endif; ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('viewAny', [AvengersMG\MGCms2019\App\Cms\Mediafiles\Mediafile::class, $current_site])): ?>
            <li>
                <a href="<?php echo e(route('mediafiles.index-from-current')); ?>"><i class="fa fa-folder"></i> Mediafiles</a>
            </li>
            <?php endif; ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('viewAny', AvengersMG\MGCms2019\App\Cms\Forms\Form::class)): ?>
            <li>
                <a href="<?php echo e(route('forms.index')); ?>"><i class="fab fa-wpforms"></i> Formularios</a>
            </li>
            <?php endif; ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('viewAny', AvengersMG\MGCms2019\App\Cms\Availabilities\Availability::class)): ?>
            <li>
                <a href="<?php echo e(route('import.index')); ?>"><i class="fa fa-upload"></i> <span>Actualizar Disponibilidad</span></a>
            </li>
            <?php endif; ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('viewAny', AvengersMG\MGCms2019\App\Cms\Banners\Banner::class)): ?>
            <li>
                <a href="<?php echo e(route('banners.index')); ?>"><i class="fa fa-bars"></i> <span>Banners</span></a>
            </li>
            <?php endif; ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('viewAny', AvengersMG\MGCms2019\App\Cms\Reviews\Review::class)): ?>
            <li>
                <a href="<?php echo e(route('reviews.index')); ?>"><i class="fab fa-tripadvisor"></i> <span>Comentarios</span></a>
            </li>
            <?php endif; ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('viewAny', AvengersMG\MGCms2019\App\Cms\Socialmedias\Socialmedia::class)): ?>
            <li>
                <a href="<?php echo e(route('socialmedias.index')); ?>"><i class="fa fa-hashtag"></i> <span>Redes Sociales</span></a>
            </li>
            <?php endif; ?>
            <?php if($user->can('viewAny', AvengersMG\MGCms2019\App\Cms\Forms\FormRequest::class)): ?>
            <li class="treeview">
                <a href="#"><i class="fa fa-bars"></i>
                    Solicitud de servicios
                    <span class="pull-right-container">
                        <i class="fa fa-angle-left pull-right"></i>
                    </span>
                </a>
                <ul class="treeview-menu">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('viewAny', AvengersMG\MGCms2019\App\Cms\Forms\FormRequest::class)): ?>
                    <li><a href="<?php echo e(route('form-services.index')); ?>"><i class="fa fa-search-minus"></i> Servicios de Viaggio</a></li>
                    <?php endif; ?>
                </ul>
            </li>
            <?php endif; ?>
            <?php echo $__env->yieldContent('custom-menus'); ?>
        </ul>
    </section>
</aside>
<?php /**PATH /home/inovationtravel/public_html/marivalvacationclub.com/vendor/avengersmg/mgcms_2019_pack/src/App/Providers/../../resources/views/admin/partials/sidenavStaticMenus.blade.php ENDPATH**/ ?>