<?php $__env->startSection('breadcrumbs'); ?>
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        <?php switch($route = Route::currentRouteName()):
            case ('mediafiles.show.dir'): ?>
                <?php $useSite = true; ?>
                <?php echo e(Breadcrumbs::render($route, $site, $path)); ?>

                <?php break; ?>
            <?php case ('mediafiles.show.dir-from-current'): ?>
                <?php $useSite = false; ?>
                <?php echo e(Breadcrumbs::render($route, $path)); ?>

                <?php break; ?>
            <?php case ('mediafiles.index'): ?>
                <?php $useSite = true; ?>
                <?php echo e(Breadcrumbs::render($route, $site)); ?>

                <?php break; ?>
            <?php default: ?> 
                <?php $useSite = false; ?>
                <?php echo e(Breadcrumbs::render($route)); ?>

        <?php endswitch; ?>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="box box-primary">
                <div class="row">
                    <div class="col-md-6">
                        <h2>Media files</h2>
                    </div>
                    <div class="col-md-6">
                        <div class="box-header with-border text-right">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', AvengersMG\MGCms2019\App\Cms\Mediafiles\FileType::class)): ?>
                            <a href="<?php echo e(route('filetypes.create')); ?>" class="btn btn-primary">Crear tipo de archivo</a>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('createDirectory', AvengersMG\MGCms2019\App\Cms\Mediafiles\Mediafile::class)): ?>
                            <a href="javascript:void(0);" class="btn btn-info" data-toggle="modal" data-target="#file-dir-modal">Crear directorio</a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-12">
            <div class="box box-body">

                
                <?php echo $__env->make('MGCms2019::admin.mediafiles.partials.dropzone', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php $url = '' ?>

                <div class="container">
                    <div class="col-md-12">
                        <?php if(isset($breadcrumbs)): ?>
                            <ol class="breadcrumb">
                                <li>
                                    <a href="<?php echo e($useSite? route('mediafiles.index', $site) : route('mediafiles.index-from-current')); ?>">Mediafiles</a>
                                    <i class="fas fa-angle-right pr-1"></i>
                                </li>
                                <?php
                                    $urlArray = [];
                                    $lastBC = count($breadcrumbs) - 1;
                                ?>
                                <?php $__currentLoopData = $breadcrumbs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $bc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                      $urlArray[] = str_slug($bc); $url = implode('/', $urlArray);
                                      $isLastBC = ($key == $lastBC);
                                    ?>
                                    <li class="<?php echo e(($isLastBC)? 'active' : ''); ?>">
                                        <a href="<?php echo e(route(($useSite? 'mediafiles.show.dir' : 'mediafiles.show.dir-from-current'), ($useSite? [$site, $url] : $url))); ?>"><?php echo e($bc); ?></a>
                                        <?php if (! ($isLastBC)): ?>
                                        <i class="fas fa-angle-right pr-1"></i>
                                        <?php endif; ?>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ol>
                        <?php endif; ?>
                    </div>
                    <div class="col-md-12">
                        <div class="container">
                             <div class="row justify-content-center">
                                <?php $__currentLoopData = $files['dirs']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $dir): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-4 media-dir">
                                    <?php $fullDir = (empty($path))? $dir : implode('/', [$path, $dir]); ?>
                                    <a href="<?php echo e(route(($useSite? 'mediafiles.show.dir' : 'mediafiles.show.dir-from-current'), ($useSite? [$site, $fullDir] : $fullDir))); ?>">
                                       <img src="<?php echo asset('/cms/svg/folder.svg'); ?>" class="img-fluid" alt=""><br />
                                        <?php echo e($dir); ?></a>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-12 row" id="sitemedia">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('viewFromSite', [AvengersMG\MGCms2019\App\Cms\Mediafiles\Mediafile::class, $site])): ?>
                            <?php $__currentLoopData = $files['files']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                  $localLang = app()->getLocale();
                                  $fileLangs = $file['model']->translations->pluck('locale');
                                  $fileLang = ($fileLangs->contains($localLang))
                                      ? $localLang
                                      : $fileLangs->first();
                                ?>
                                <div class="col-md-3">
                                    <div class="media-item media-item-<?php echo e($file['model']->id); ?>" data-toggle="modal" data-target="#file-detail-modal"
                                         data-id="<?php echo e($file['model']->id); ?>"
                                         data-route="<?php echo e(route('mediafiles.show', $file['model']->id)); ?>"
                                         data-delete="<?php echo e(route('mediafiles.destroy', $file['model']->id)); ?>"
                                         data-update="<?php echo e(route('mediafiles.update', $file['model']->id)); ?>"
                                         data-path="<?php echo e($public_path); ?>"
                                         data-type="<?php echo e(($file['model']->type) ? $file['model']->type->id : ''); ?>"
                                         data-lang="<?php echo e($fileLang); ?>"
                                         data-lang-delete-routes='<?php echo json_encode(
                                             collect(
                                                 app()->make('translatable.locales')->all()
                                             )->mapWithKeys(function($locale) use ($file){
                                                 return ["{$locale}" => route('mediafiles.translations.destroy', [$file['model'], $locale])];
                                             })->all()) ?>'
                                        >
                                        <div class="file-image <?php if(!$file['model']->is_image): ?> text-center <?php endif; ?>" <?php if($file['model']->is_image): ?> style="background-image: url('<?php echo e(url($file['model']->path)); ?>')" <?php endif; ?>>
                                            <?php if(!$file['model']->is_image): ?>
                                                <span class="fiv-viv fiv-icon-<?php echo e($file['model']->file_extension); ?> fiv-size-xl"></span>
                                            <?php endif; ?>
                                        </div>
                                        <?php if($file['model']->type): ?>
                                            <p class="file-type type-<?php echo e($file['model']->type->type); ?>"><?php echo e($file['model']->type->type); ?></p>
                                        <?php endif; ?>
                                        <p class="file-image-languages text-center"><?php echo e($fileLangs->implode(', ')); ?></p>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <?php echo $__env->make('MGCms2019::admin.mediafiles.partials.modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('MGCms2019::admin.layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/inovationtravel/public_html/marivalvacationclub.com/vendor/avengersmg/mgcms_2019_pack/src/App/Providers/../../resources/views/admin/mediafiles/index.blade.php ENDPATH**/ ?>