<?php
    $lang = app()->getLocale();
?>
<?php $__env->startSection('breadcrumbs'); ?>
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        <?php echo e(Breadcrumbs::render(Route::currentRouteName(), $gallery, $gallery->page, $lang)); ?>

    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php echo $__env->make('MGCms2019::admin.partials.formErrors', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="box box-default">
        <div class="box-header with-border">
            <h3 class="box-title">Galer&iacute;a</h3>
        </div>
        <!-- /.box-header -->
            <?php echo Form::open(['route' => ['galleries.update.gallery', $gallery], 'method' => 'put', 'class' => 'gallery-form']); ?>

            <div class="form-group col-md-12 input-images">
                <div class="row">
                        <div class="form-group col-md-6">
                            <label for="name">Nombre</label>
                            <input type="text" class="form-control" name="name" value="<?php echo e($gallery->name); ?>" required />
                        </div>
                        <div class="form-group col-md-6">
                            <label for="name_es">Nombre (espa&ntilde;ol)</label>
                            <input type="text" class="form-control" name="name_es" value="<?php echo e($gallery->name_es); ?>" required />
                        </div>
                    </div>
                <?php $__currentLoopData = $arr_images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <input type="hidden" name="images[]" id="input-media-<?php echo e($image); ?>" value="<?php echo e($image); ?>" />
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $gallery->page)): ?>
            <div class="form-group col-md-12">
                <div class="form-check">
                    <?php
                        /* Variables para envío de GalleryFeature de especiales */
                        $specialClass = AvengersMG\MGCms2019\App\Cms\Components\Specials\Special::class;
                        $specialChecked = in_array($specialClass, old('gallery_features', []))
                        ? true
                        : ($gallery->features()->where('featurable_type', $specialClass)->count() > 0);
                    ?>
                    <?php echo Form::checkbox('gallery_features_specials', $specialClass, $specialChecked, ["class" => "form-group form-check-input", "name" => "gallery_features[]"]); ?>

                    <label class="gallery_features_specials">Inyectar im&aacute;genes de tipo &quot;header&quot; desde Especiales</label>
                    <small class="form-text text-muted">Si una imagen inyectada es eliminada de esta galer&iacute;a, esta volver&aacute; a ser inyectada por otros procesos mientras que la p&aacute;gina a la que pertenece exista y tenga estado &quot;published&quot;.</small>
                </div>
                <div class="form-check">
                    <?php echo Form::checkbox('gallery_is_mobile', "1", $gallery->is_mobile, ["class" => "form-group form-check-input", "name" => "is_mobile"]); ?>

                    <label class="gallery_is_mobile">Para uso en dispositivos m&oacute;viles.</label>
                    <small class="form-text text-muted">Si la inyecci&oacute;n de im&aacute;genes est&aacute; activa, solo tomar&aacute; medios de tipo &quot;header_mobile&quot;.</small>
                </div>
            </div>

            <div class="col-md-12 text-right">
                <a href="javascript:void(0);" class="btn btn-info submit-using-ajax" data-on-action-success-message="Galería guardada">Guardar</a>
                <button type="submit" class="btn btn-info">Guardar y cerrar</button>
            </div>

            <?php endif; ?>
        <?php echo Form::close(); ?>


        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $gallery->page)): ?>
        <div class="col-md-12 mt-5">
            <?php echo Form::open(['route' => 'page.upload.file', 'method' => 'POST', 'files'=> true, 'class' => 'dropzone', 'id' => 'gallery-dropzone']); ?>

            <input type="hidden" name="page" id="page" value="<?php echo e($gallery->page_id); ?>" />
            <input type="hidden" name="lang" id="lang" value="<?php echo e($lang); ?>" />
            <div class="fallback">
                <input name="file" type="file" multiple />
            </div>
            <?php echo Form::close(); ?>

        </div>
        <?php endif; ?>

        <div class="col-md-12 gallery-items">
            <?php $__currentLoopData = $gallery->items->sortBy('priority'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="img-choose" id="media-<?php echo e($item->mediafile->id); ?>" data-action="media-action-<?php echo e($item->mediafile->id); ?>" style="background-image: url(<?php echo e($item->mediafile->path); ?>)">
                    <img src="/cms/images/delete.png" alt="" />
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <div class="col-md-12 gallery-page-media">
            <div class="row gallery-grid selectable-media" id="extra-mediafiles">
                <?php $__currentLoopData = $mediafiles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-md-3">
                        <div class="media-page" style="background-image: url(<?php echo e($image->path); ?>)">
                            <div class="media-actions <?php echo e((in_array($image->id, $arr_images)) ? 'disabled-image' : 'add-to-gallery'); ?>" id="media-action-<?php echo e($image->id); ?>" data-src="<?php echo e($image->path); ?>" data-media="<?php echo e($image->id); ?>">
                                <img src="<?php echo e(asset('cms/images/add.png')); ?>" alt="" />
                                <p><?php echo e($image->translations->implode('locale', ', ')); ?></p>
                            </div>
                            <div class="selected-overlay"></div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        <div class="col-md-12 text-right">
            <a id="load-extra-mediafiles" class="btn btn-info" data-add-icon-src="<?php echo e(asset('cms/images/add.png')); ?>" data-load-url="<?php echo e(route('galleries.extra-mediafiles', $gallery->id)); ?>" data-actions-class="add-to-gallery" href="javascript:void(0);">Cargar m&aacute;s im&aacute;genes</a>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('MGCms2019::admin.layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/inovationtravel/public_html/marivalvacationclub.com/vendor/avengersmg/mgcms_2019_pack/src/App/Providers/../../resources/views/admin/components/galleries/edit.blade.php ENDPATH**/ ?>