<?php
    $user = Auth::user();
    $can_update_page = $user->can('update', $page);
    $can_view_mediafile = $user->can('viewFromSite', [AvengersMG\MGCms2019\App\Cms\Mediafiles\Mediafile::class, $page->site]);
    $can_create_mediafile = $user->can('create', [AvengersMG\MGCms2019\App\Cms\Mediafiles\Mediafile::class, $page->site]);
    $can_update_mediafile = $user->can('updateFromSite', [AvengersMG\MGCms2019\App\Cms\Mediafiles\Mediafile::class, $page->site]);
    $can_delete_mediafile = $user->can('deleteFromSite', [AvengersMG\MGCms2019\App\Cms\Mediafiles\Mediafile::class, $page->site]);
?>
<?php if($can_update_page && $can_create_mediafile): ?>
<div class="col-md-12">
  <?php echo Form::open(['route' => 'page.upload.file', 'method' => 'POST', 'files'=> true, 'class' => 'dropzone', 'id' => 'dropzone']); ?>

  <input type="hidden" name="page" id="page" value="<?php echo e($page->id); ?>">
  <input type="hidden" name="lang" id="lang" value="<?php echo e($lang); ?>">
  <div class="fallback">
      <input name="file" type="file" multiple/>¡¡
  </div>
  <?php echo Form::close(); ?>

</div>
<?php endif; ?>
<div class="col-md-12 row" id="zone-content">
    <?php if($can_update_page && $can_view_mediafile): ?>
    <div class="col-md-12" id="pagemedia">
        <div class="row page-media-container">
            <?php $__currentLoopData = $page->mediafiles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                  $fileLangs = $file->translations->pluck('locale');
                  $fileLang = ($fileLangs->contains($lang))
                      ? $lang
                      : $fileLangs->first();
                ?>
                <div class="col-md-3">
                    <div class="media-item media-item-<?php echo e($file->id); ?> " data-toggle="modal" data-target="#file-detail-modal"
                         data-id="<?php echo e($file->id); ?>"
                         data-route="<?php echo e(route('page.get.file', $file)); ?>"
                         data-delete="<?php echo e(route('mediafiles.destroy', $file)); ?>"
                         data-update="<?php echo e(route('files.update')); ?>"
                         data-path="<?php echo e(asset($file->path)); ?>"
                         data-type="<?php echo e(($file->type) ? $file->type->id : ''); ?>"
                         data-lang="<?php echo e($fileLang); ?>"
                         data-lang-delete-routes='<?php echo json_encode(
                             collect(
                                 app()->make('translatable.locales')->all()
                             )->mapWithKeys(function($locale) use ($file){
                                 return ["{$locale}" => route('mediafiles.translations.destroy', [$file, $locale])];
                             })->all()) ?>'
                        >
                        <div class="file-image" style="background-image: url('<?php echo e(asset($file->path)); ?>')">
                        </div>
                        <?php if($file->type): ?>
                            <p class="file-type type-<?php echo e($file->type->type); ?>"><?php echo e($file->type->type); ?></p>
                        <?php endif; ?>
                        <p class="file-image-languages text-center"><?php echo e($fileLangs->implode(', ')); ?></p>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
    <?php endif; ?>
</div>

<!-- Modal -->
<?php echo $__env->make('MGCms2019::admin.pages.partials.mediaModal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /home/inovationtravel/public_html/marivalvacationclub.com/vendor/avengersmg/mgcms_2019_pack/src/App/Providers/../../resources/views/admin/pages/partials/media.blade.php ENDPATH**/ ?>