<!doctype html>
<html lang="<?php echo e($lang); ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <link rel="manifest" href="<?php echo e(asset('/favicon/manifest.json')); ?>">
    <meta name="msapplication-TileColor" content="#ffffff">
    <meta name="msapplication-TileImage" content="<?php echo e(asset('/favicon/ms-icon-144x144.png')); ?>">
    <meta name="theme-color" content="#ffffff">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    
    <!-- Cookie Consent by TermsFeed https://www.TermsFeed.com -->
    <script type="text/javascript" src="https://www.termsfeed.com/public/cookie-consent/4.2.0/cookie-consent.js" charset="UTF-8"></script>
    <script type="text/javascript" charset="UTF-8">
    document.addEventListener('DOMContentLoaded', function () {
    cookieconsent.run({"notice_banner_type":"simple","consent_type":"express","palette":"light","language":"en","page_load_consent_levels":["strictly-necessary"],"notice_banner_reject_button_hide":false,"preferences_center_close_button_hide":false,"page_refresh_confirmation_buttons":false,"website_name":"Marival Vacation Club","website_privacy_policy_url":"https://marivalvacationclub.com/privacy-notice"});
    });
    </script>
    
    <noscript>Free cookie consent management tool by <a href="https://www.termsfeed.com/">TermsFeed Generator</a></noscript>
    <!-- End Cookie Consent by TermsFeed https://www.TermsFeed.com -->



    
    <title><?php echo e(($page->meta_title != null) ? $page->meta_title : $page->site->meta_title); ?></title>
    <meta name="description" content="<?php echo e(($page->meta_description != null) ? $page->meta_description : $page->site->meta_description); ?>">

    <?php if($page->form_id): ?>
        
        <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    <?php endif; ?>

    
    <link rel="preconnect" href="https://fonts.gstatic.com"> 
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/meyer-reset/2.0/reset.min.css">
    <link rel='stylesheet' href='https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css'>
    <link rel="stylesheet" href="<?php echo e(asset('css/app.css')); ?>">
    <style>
      /* Estilos del banner informativo */
       .info-banner {
            background-color: #222;
            color: white;
            padding: 12px 16px;
        }

        .banner-container {
            max-width: 1280px;
            margin: 0 auto;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .banner-content {
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .info-icon {
            width: 20px;
            height: 20px;
            flex-shrink: 0;
            fill: currentColor;
        }

        .banner-text {
            font-size: 14px;
            text-align: center;
        }

        .banner-text .highlight {
            font-weight: 600;
        }

        .banner-text .desktop-only {
            display: none;
        }

        .banner-link {
            color: white;
            text-decoration: underline;
            margin-left: 8px;
            transition: text-decoration 0.2s ease;
        }

        .banner-link:hover {
            text-decoration: none;
        }
          /* Media queries para responsive */
        @media (min-width: 640px) {

            .banner-text .desktop-only {
                display: inline;
            }
        }
         /* Estados de focus para accesibilidad */
        .banner-link:focus {
            outline: 2px solid white;
            outline-offset: 2px;
            border-radius: 2px;
        }
    </style>

    
    <?php echo $page->site->schema; ?>



    <link rel="canonical" href="<?php echo e(url($page->perman_link)); ?>" />

    
    <meta name="dc.title" content="<?php echo e(($page->meta_title != null) ? $page->meta_title : $page->site->meta_title); ?>" />
    <meta name="dc.description" content="<?php echo e(($page->meta_description != null) ? $page->meta_description : $page->site->meta_description); ?>" />
    <meta name="dc.source" content="<?php echo e(url($page->perman_link)); ?>" />

    <meta property="og:locale" content="<?php echo e($lang); ?>"/>
    <meta property="og:locale:alternate" content="<?php echo e(($lang == 'en') ? 'es' : 'en'); ?>" />
    <meta property="og:type" content="website" />
    <meta property="og:title" content="<?php echo e(($page->meta_title != null) ? $page->meta_title : $page->site->meta_title); ?>" />
    <meta property="og:description" content="<?php echo e(($page->meta_description != null) ? $page->meta_description : $page->site->meta_description); ?>" />
    <meta property="og:url" content="<?php echo e(url($page->perman_link)); ?>" />
    <meta property="og:site_name" content="<?php echo e($page->site->name); ?>" />
    <meta property="og:image" content="<?php echo e(($featured = $page->getFirst('featured_image')) ? url($featured->path) : '#'); ?>" />

    <link rel="apple-touch-icon" sizes="60x60" href="<?php echo e(asset('/favicon/apple-icon-60x60.png')); ?>">
    <link rel="apple-touch-icon" sizes="72x72" href="<?php echo e(asset('/favicon/apple-icon-72x72.png')); ?>">
    <link rel="apple-touch-icon" sizes="76x76" href="<?php echo e(asset('/favicon/apple-icon-76x76.png')); ?>">
    <link rel="apple-touch-icon" sizes="114x114" href="<?php echo e(asset('/favicon/apple-icon-114x114.png')); ?>">
    <link rel="apple-touch-icon" sizes="120x120" href="<?php echo e(asset('/favicon/apple-icon-120x120.png')); ?>">
    <link rel="apple-touch-icon" sizes="144x144" href="<?php echo e(asset('/favicon/apple-icon-144x144.png')); ?>">
    <link rel="apple-touch-icon" sizes="152x152" href="<?php echo e(asset('/favicon/apple-icon-152x152.png')); ?>">
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('/favicon/apple-icon-180x180.png')); ?>">
    <link rel="icon" type="image/png" sizes="192x192"  href="<?php echo e(asset('/favicon/android-icon-192x192.png')); ?>">
    <link rel="icon" type="image/png" sizes="32x32" href="<?php echo e(asset('/favicon/favicon-32x32.png')); ?>">
    <link rel="icon" type="image/png" sizes="96x96" href="<?php echo e(asset('/favicon/favicon-96x96.png')); ?>">
    <link rel="apple-touch-icon" sizes="57x57" href="<?php echo e(asset('/favicon/apple-icon-57x57.png')); ?>">
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(asset('/favicon/favicon-16x16.png')); ?>">

   <!-- Google Tag Manager -->
    <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
    new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
    j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
    'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
    })(window,document,'script','dataLayer','GTM-N5G6MR3');</script>
    <!-- End Google Tag Manager -->
    
</head>
<body class="body m6">


 <!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-N5G6MR3"
    height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
    <!-- End Google Tag Manager (noscript) -->
    


<?php echo $__env->renderWhen($page, 'partials.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path'])); ?>
<?php echo $__env->renderWhen($page, 'templates.'.$page->template, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path'])); ?>

<?php echo $__env->renderWhen($page, 'partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path'])); ?>
 
<script src="https://ajax.googleapis.com/ajax/libs/webfont/1.4.7/webfont.js" type="text/javascript" async></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html5shiv/3.7.3/html5shiv.min.js" type="text/javascript" async></script>
<script type="text/javascript" async>!function(o,c){var n=c.documentElement,t=" w-mod-";n.className+=t+"js",("ontouchstart"in o||o.DocumentTouch&&c instanceof DocumentTouch)&&(n.className+=t+"touch")}(window,document);</script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/prefixfree/1.0.7/prefixfree.min.js"></script>

<script src="<?php echo e(asset('/js/app.js')); ?>" async></script>





<script>
    (function(w,d,u){
            var s=d.createElement('script');s.async=true;s.src=u+'?'+(Date.now()/60000|0);
            var h=d.getElementsByTagName('script')[0];h.parentNode.insertBefore(s,h);
    })(window,document,'https://cdn.bitrix24.mx/b30783165/crm/site_button/loader_1_lezefc.js');
</script>

</body>
</html><?php /**PATH /home/inovationtravel/public_html/marivalvacationclub.com/resources/views/layouts/main.blade.php ENDPATH**/ ?>