<?php
    $user = Auth::user();
?>
<?php echo Form::model($site, ['route' => ['sites.update', $site], 'method' => 'PUT', 'files' => true, 'class' => 'settings-form' ]); ?>

<div class="col-md-8 text-center">
    <img src="<?php echo e(asset($site->logo)); ?>" class="img-fluid" alt="">
</div>
<div class="form-group col file-space">
    <div class="upload-btn-wrapper">
      <button class="btn"><i class="fas fa-file-upload"></i> <br />Click para subir archivo </button>
      <input type="file" class="file" name="logo" placeholder="Site name" />
    </div>
</div>
<?php if($user->can('updateDomain', AvengersMG\MGCms2019\App\Cms\Sites\Site::class) || $user->can('updateOwnDomain', $site)): ?>
<div class="form-group col">
    <label for="domain">Dominio del sitio</label>
    <?php echo Form::text('domain', old('domain'), ['class' => 'form-control']); ?>

</div>
<?php endif; ?>
<div class="form-group col">
    <label for="name">Nombre del sitio</label>
    <input type="text" class="form-control" name="name" value="<?php echo e($site->name); ?>" placeholder="Site name" required>
</div>
<div class="form-group col">
    <label for="phone">Tel&eacute;fono (<?php echo e(app()->getLocale()); ?>)</label>
    <input type="text" class="form-control" name="phone" value="<?php echo e($site->phone); ?>" placeholder="Site Phone">
</div>
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $site)): ?>
<div class="col-md-12 text-left">
    <input name="lang" type="hidden" value="<?php echo e($lang); ?>">
    <button type="submit" class="btn btn-info">Actualizar</button>
</div>
<?php endif; ?>
<?php echo Form::close(); ?>

<?php /**PATH /home/inovationtravel/public_html/marivalvacationclub.com/vendor/avengersmg/mgcms_2019_pack/src/App/Providers/../../resources/views/admin/sites/partials/settings.blade.php ENDPATH**/ ?>