<?php $__env->startSection('breadcrumbs'); ?>
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        <?php switch($route = Route::currentRouteName()):
            case ('pages.index'): ?>
                <?php
                    $createRoute = route('pages.create', $site);
                    $updatePermaLinksRoute = route('update.permalinks', $site);
                ?>
                <?php echo e(Breadcrumbs::render($route, $site)); ?>

                <?php break; ?>
            <?php default: ?>
                <?php
                    $createRoute = route('pages.create-from-current');
                    $updatePermaLinksRoute = route('update.permalinks-from-current');
                ?>
                <?php echo e(Breadcrumbs::render($route)); ?>

        <?php endswitch; ?>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="box box-default">
        <div class="box-header row">
            <div class="col-md-12">
                <h3 class="box-title">Páginas</h3>
            </div>
            <div class="col">
                <section class="status row">
                    <article class="col-md-3">
                        <strong>Estados:</strong>
                    </article>
                    <article class="col-md-3">
                        <i>Published</i>
                        <i class="fas label-published"></i>
                    </article>
                    <article class="col-md-3">
                        <i>Review</i>
                        <i class="fas label-review"></i>
                    </article>
                    <article class="col-md-3">
                        <i>Hidden</i>
                        <i class="fas label-hidden"></i>
                    </article>
                </section>
            </div>
            <div class="col text-right">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('updateFromSite', [AvengersMG\MGCms2019\App\Cms\Pages\Page::class, $site])): ?>
                <a href="<?php echo e($updatePermaLinksRoute); ?>" class="btn btn-warning">Actualizar <i>permalinks</i></a>
                <a href="http://<?php echo e($site->domain); ?>" target="_blank" class="btn btn-primary">
                    <i class="fa fa-eye"></i> Ver sitio</a>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', [AvengersMG\MGCms2019\App\Cms\Pages\Page::class, $site])): ?>
                <a href="<?php echo e($createRoute); ?>" class="btn btn-primary">
                    <i class="fa fa-plus"></i> Agregar página</a>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('updateFromSite', [AvengersMG\MGCms2019\App\Cms\Pages\Page::class, $site])): ?>
                <button class="btn btn-info" id="reorder">
                    <i class="fa fa-bars"></i> Reordenar</button>
                <?php endif; ?>
            </div>
            <div class="col-md-12">
                <?php echo $__env->make('MGCms2019::admin.partials.formErrors', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                
                <div class="dd model-main-tree" id="pages" data-url="<?php echo e(route('pages.tree')); ?>">
                    <ol class="dd-list">
                        <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="dd-item" data-id="<?php echo e($page->id); ?>">
                                <div class="dd-handle" id="<?php echo e($page->id); ?>">
                                    <section class="page-status"><i class="fas label-<?php echo e($page->status); ?>"></i>
                                        <span><p><?php echo e($page->translateOrDefault('es')->name); ?></p> </span>
                                        <?php if(!$page->seo): ?>
                                            <span class="label"> <i class="far fa-chart-bar"></i></span>
                                        <?php endif; ?>
                                        <?php if(isset($page->children)): ?>
                                            <button class="btn btn-link collapsed" type="button" data-toggle="collapse" data-target="#nodePage<?php echo e($page->id); ?>" aria-expanded="true" aria-controls="#nodePage<?php echo e($page->id); ?>">
                                                <i class="fas fa-chevron-up"></i>
                                            </button>
                                        <?php endif; ?>
                                    </section>
                                    <ul class="item-actions">
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $page)): ?>
                                        <?php $__currentLoopData = $page->getTranslationsArray(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang => $translation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li>
                                                <a href="<?php echo e(route('pages.show', [$page->id, $lang])); ?>" class="page-actions label-info edit">
                                                    <?php if($lang == 'es'): ?>
                                                        <img src="<?php echo e(asset('cms/images/lang/mexico.png')); ?>" alt="" class="">
                                                       <i class="fas label-<?php echo e($page->translate('es')->status); ?>"></i>
                                                    <?php else: ?>
                                                        <img src="<?php echo e(asset('cms/images/lang/united-states-of-america.png')); ?>" alt="" class="">
                                                        <i class="fas label-<?php echo e($page->translate('en')->status); ?>"></i>
                                                    <?php endif; ?>
                                                </a>
                                            </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                        <li>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', [AvengersMG\MGCms2019\App\Cms\Pages\Page::class, $site])): ?>
                                            <a href="<?php echo e(route('pages.addNode', [$page])); ?>" class="label label-primary create"> <i class="fa fa-plus"></i></a>
                                            <?php endif; ?>
                                        </li>
                                        <li>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete', $page)): ?>
                                            <a href="<?php echo e(route('pages.destroy', [$page])); ?>" class="label label-danger delete-model"><i class="far fa-trash-alt"></i></a>
                                            <?php endif; ?>
                                        </li>
                                    </ul>
                                </div>
                                <?php echo $__env->make('MGCms2019::admin.pages.node', ['page' => $page], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ol>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('MGCms2019::admin.layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/inovationtravel/public_html/marivalvacationclub.com/vendor/avengersmg/mgcms_2019_pack/src/App/Providers/../../resources/views/admin/pages/index.blade.php ENDPATH**/ ?>