<div class="slider-home stick-dots">
    @php $pictures = $page->getGallery('sliderhome'); @endphp
    @if($pictures)
        @foreach($pictures as $picture)
          <div class="slide">
            <div class="slide__img">
              <img src="" alt="" data-lazy="{{ asset($picture->path) }}" class="full-image animate__animated" data-animation-in="zoomInImage"/>
            </div>
            <div class="slide__content">
              <div class="slide__content--headings">
                <h2 class="animate__animated" data-animation-in="animate__fadeInUp">{{ $picture->title }}</h2>
                <p class="animate__animated" data-animation-in="animate__fadeInUp" data-delay-in="0.3">{{ $picture->description }}</p>
              </div>
            </div>
          </div>
        @endforeach  
    @endif
  </div>
   <div class="info-banner">
        <div class="banner-container">
            <!-- Contenido del mensaje -->
            <div class="banner-content">
                <!-- Icono de información -->
                <svg class="info-icon" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"></path>
                </svg>
                
                <!-- Texto del mensaje -->
                <div class="banner-text">
                    <span class="highlight">@lang('global.info-top.title')</span>
                    <span class="desktop-only">@lang('global.info-top.description')</span>
                    <a href="@lang('global.info-top.url')" class="banner-link">
                        @lang('global.info-top.text-url')
                    </a>
                </div>
            </div>
        </div>
    </div>
  <section class="text-gray-700 body-font">
    <div class="container mx-auto flex px-5 py-40 md:flex-row flex-col items-center">
      <div class="lg:flex-grow md:w-full lg:pr-24 md:pr-16 flex flex-col md:items-center md:text-left mb-16 md:mb-0 items-center text-center">
        <span class="text-center text-gray-300" >@lang('global.welcome')</span>
        <h1 class="title-font sm:text-7xl text-3xl mb-4 font-medium text-gray-900 text-center">{{ $page->primary }}</h1>
        <span class="mt-8 mb-8 leading-loose text-center text-gray-400">{!! $page->description !!}</span>
        <div class="parallax">
          @php $pictures = $page->getGallery('parallax'); @endphp
            @if($pictures)
              @foreach($pictures as $picture)
                <img src="{{ asset($picture->path) }}" alt="image" class="shadow-2xl"/>
              @endforeach  
          @endif
        </div>
      </div>
    </div>
  </div>
  </section>
  @foreach($page->cards->sortBy('priority') as $index => $card)
    <section class="text-gray-700 body-font">
        <div class="container mx-auto flex px-5 py-40 md:flex-row flex-col items-center">
            @if($card->priority%2 == 0 )
                <div class=" p-20 lg:flex-grow md:w-1/2 lg:pr-24 md:pr-16 flex flex-col md:items-start md:text-left mb-16 md:mb-0 items-center text-center">
                    <h3 class="title-font sm:text-4xl text-3xl mb-4 font-medium text-gray-900">{{ $card->title }}</h3>
                    <p class="mb-8 leading-relaxed">{!! $card->body !!}</p>
                    {{-- <div class="flex justify-center">
                    <button class="inline-flex text-white bg-indigo-500 border-0 py-2 px-6 focus:outline-none hover:bg-indigo-600 rounded text-lg">Button</button>
                    <button class="ml-4 inline-flex text-gray-700 bg-gray-200 border-0 py-2 px-6 focus:outline-none hover:bg-gray-300 rounded text-lg">Button</button>
                    </div> --}}
                </div>
                <div class="lg:max-w-lg lg:w-full md:w-1/2 w-5/6 p-1">
                    <img src="{{ asset($card->image) }}" alt="" class="shadow-2xl">
                </div>
            @else
                <div class="lg:max-w-lg lg:w-full md:w-1/2 w-5/6 p-1">
                    <img src="{{ asset($card->image) }}" alt="" class="shadow-2xl">
                </div>
                <div class="lg:flex-grow md:w-1/2 lg:pr-24 md:pr-16 flex flex-col md:items-start md:text-left mb-16 md:mb-0 items-center text-center p-20">
                    <h3 class="title-font sm:text-4xl text-3xl mb-4 font-medium text-gray-900">{{ $card->title }}</h3>
                    <p class="mb-8 leading-relaxed">{!! $card->body !!}</p>
                    {{-- <div class="flex justify-center">
                    <button class="inline-flex text-white bg-indigo-500 border-0 py-2 px-6 focus:outline-none hover:bg-indigo-600 rounded text-lg">Button</button>
                    <button class="ml-4 inline-flex text-gray-700 bg-gray-200 border-0 py-2 px-6 focus:outline-none hover:bg-gray-300 rounded text-lg">Button</button>
                    </div> --}}
                </div>
            @endif
        </div>
    </section>
  @endforeach

@php $destinos = $page->getRelatedPage('destinos'); @endphp

{{-- @if($destinos)
    <div class="md:container md:mx-auto destiny-content">
      <h3 class="title-font sm:text-4xl text-3xl mb-4 font-medium text-gray-900 text-center">{{$destinos->title}}</h3>
        <div class="grid grid-cols-3 gap-4 content-center">
              @foreach($destinos->children as $child)
                <div class="bg-gray-100 rounded py-10 text-center transition duration-500 ease-in-out hover:shadow-2xl">
                  <a href="{{ $child->perman_link }}">
                    @if($img = $child->getFirst('thumbnail'))
                        <img src="{{ asset($img->path) }}" alt="Image" class="destiny-icon" />
                      @else
                        <div class="py-10"></div>
                    @endif
                    {{ ($child->name) }}
                  </a>
                </div>
              @endforeach    
        </div> 
    </div>
@endif --}}

@if($destinos)
<div id="destiny">
  <div class="container">
    <h3 class="title-font sm:text-4xl text-3xl mb-4 font-medium text-gray-900">{{$destinos->title}}</h3>
      <div class="grid">
        <div class="column-xs-12">
          <ul class="slider">
            @foreach($destinos->children as $child)
            <li class="slider-item {{ ($loop->first) ? 'active' : '' }}"">
              <div class="grid vertical">
                <div class="column-xs-12 column-md-2 hide-mobile shadow-2xl">
                  <div class="intro">
                    <a href="{{ $child->perman_link }}">
                      <h6 class="title"><span class="underline"> {{ ($child->name) }}</span></h6>
                    </a>
                  </div>
                </div>
                <div class="column-xs-12 column-md-10">
                  <div class="image-holder">
                    @if($img = $child->getFirst('header'))
                      <img src="{{ asset($img->path) }}" alt="Image" />
                    @else
                      <div class="py-10"></div>
                    @endif
                  </div>
                  <div class="grid">
                    <div class="column-xs-12 column-md-9">
                      <div class="intro show-mobile shadow-2xl">
                        <a href="{{ $child->perman_link }}">
                          <h6 class="title"><span class="underline">{{ ($child->name) }}</span></h6>
                        </a>
                      </div>
                      <p class="description">{{ ($child->sub_title) }}</p>
                    </div>
                  </div>
                </div>
              </div>
            </li>
            @endforeach  
          </ul>
        <div class="grid">
          <div class="column-xs-12">
            <div class="controls">
                <button class="previous">
                  <span class="visually-hidden">Previous</span>
                  <span class="icon arrow-left" aria-hidden="true"></span>
                </a>
                <button class="next">
                  <span class="visually-hidden">Next</span>
                  <span class="icon arrow-right" aria-hidden="true"></span>
                </a>
              </div>
            </div>
        </div>
      </div>
    </div>
  </div>
</div>
@endif

