<a href="{{ (app()->getLocale() == 'en') ? url('/') : url('/es') }}"class="back-button">
  <i class="fas fa-chevron-left"></i>&#10094;
</a>
<section class="text-gray-700 body-font px-5 py-20">
    <div class="container grid grid-cols-3 gap-4 mx-auto ">
        <div class="col-span-3 sm:col-span-2">
            @if($img = $page->getFirst('header'))
              <div class="header-wrapper">
                  <img src="{{ asset($img->path) }}" alt="Image" class=""/>
              </div>
            @else
              <div class="p-3-m"></div>
            @endif 
        </div>
        <div class="col-span-3 sm:col-span-1">
            <h1 class="title-font sm:text-4xl text-3xl mb-4 font-medium text-gray-900">{{ $page->primary }}</h1>
            <p class="mb-8 leading-relaxed">{!! $page->description !!}</p>
        </div>
      </div>
  </section>
  <section class="text-gray-700 body-font">
    <div class="container mx-auto flex px-5 py-20 md:flex-row flex-col items-center">
      <div class="">
        <p class="mb-8 leading-relaxed">{!! $page->excerpt !!}</p>
      </div>
    </div>
  </section>
  <section class="text-gray-700 body-font px-5 py-20">
    @php $pictures = $page->getGallery('gallery'); @endphp
    @if($pictures) 
      <div class="grid grid-cols-3 gap-4 img-grid">
          @foreach($pictures as $picture)
                <a href="{{ asset($picture->path) }}" data-fancybox="gallery" data-caption="{{$picture->title}}">
                  <img src="{{ asset($picture->path) }}" alt="" />
                </a>
          @endforeach
      </div>
    @endif
  </section>