<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <link rel="manifest" href="https://marivalvacationclub.com/favicon/manifest.json">
    <meta name="msapplication-TileColor" content="#ffffff">
    <meta name="msapplication-TileImage" content="https://marivalvacationclub.com/favicon/ms-icon-144x144.png">
    <meta name="theme-color" content="#ffffff">
    <meta name="csrf-token" content="Gk6cmx6xX0f6JUCq4Z5rboAogrKnJuxMMFeKYUjV">

    
    <title>Your Safety is Our Priority | Avoid Fraud at Marival Vacation Club</title>
    <meta name="description" content="Find out how to identify and avoid Marival Vacation Club scams - your vacation deserves security!">
    <link rel="stylesheet" href="https://marivalvacationclub.com/css/app.css"> 
    <meta name="dc.title" content="Your Safety is Our Priority | Avoid Fraud at Marival Vacation Club" />
    <meta name="dc.description" content="Find out how to identify and avoid Marival Vacation Club scams - your vacation deserves security!" />
    <meta name="dc.source" content="https://marivalvacationclub.com" />

    <meta property="og:locale" content="en"/>
    <meta property="og:locale:alternate" content="es" />
    <meta property="og:type" content="website" />
    <meta property="og:title" content="Your Safety is Our Priority | Avoid Fraud at Marival Vacation Club" />
    <meta property="og:description" content="Find out how to identify and avoid Marival Vacation Club scams - your vacation deserves security!" />
    <meta property="og:url" content="https://marivalvacationclub.com/fraud-notice" />
    <meta property="og:site_name" content="Marival Vacation Club" />
    <meta property="og:image" content="https://marivalvacationclub.com/mediafiles/pages/2021/02/1/adobestock-271570466-home1.jpeg" />

    <link rel="apple-touch-icon" sizes="60x60" href="https://marivalvacationclub.com/favicon/apple-icon-60x60.png">
    <link rel="apple-touch-icon" sizes="72x72" href="https://marivalvacationclub.com/favicon/apple-icon-72x72.png">
    <link rel="apple-touch-icon" sizes="76x76" href="https://marivalvacationclub.com/favicon/apple-icon-76x76.png">
    <link rel="apple-touch-icon" sizes="114x114" href="https://marivalvacationclub.com/favicon/apple-icon-114x114.png">
    <link rel="apple-touch-icon" sizes="120x120" href="https://marivalvacationclub.com/favicon/apple-icon-120x120.png">
    <link rel="apple-touch-icon" sizes="144x144" href="https://marivalvacationclub.com/favicon/apple-icon-144x144.png">
    <link rel="apple-touch-icon" sizes="152x152" href="https://marivalvacationclub.com/favicon/apple-icon-152x152.png">
    <link rel="apple-touch-icon" sizes="180x180" href="https://marivalvacationclub.com/favicon/apple-icon-180x180.png">
    <link rel="icon" type="image/png" sizes="192x192"  href="https://marivalvacationclub.com/favicon/android-icon-192x192.png">
    <link rel="icon" type="image/png" sizes="32x32" href="https://marivalvacationclub.com/favicon/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="96x96" href="https://marivalvacationclub.com/favicon/favicon-96x96.png">
    <link rel="apple-touch-icon" sizes="57x57" href="https://marivalvacationclub.com/favicon/apple-icon-57x57.png">
    <link rel="icon" type="image/png" sizes="16x16" href="https://marivalvacationclub.com/favicon/favicon-16x16.png">    
</head>
<style>
	.container{
		margin: 4em auto;
		max-width: 1280px;
	}
	table{
		margin: 1em auto;
		width: 90%;
	}
	.page-title{
	    margin-bottom:20px;
	}
	.section-title{
	    margin-bottom:10px;
	    margin-top:30px;
	    font-weight:bold;
	}
	.container-text p{
	    margin-top:15px;
	}
	.alert{
	    background: #f3f3f3;
        padding: 20px;
        border-radius: 5px;
        margin: 30px 0;
	}
	.nav-menu{
	    position:relative !important;
	    margin:30px 0;
	    border-bottom:1px solid #222;
	    padding-bottom:20px;
	}
	.logo{
	    width:210px;
	}
	.nav .item{
	    display: inline-block;
        vertical-align: middle;
        width:45%;
	}
	.nav .item.text-start{
	    text-align:left;
	}
	.nav .item.text-end{
	    text-align:right;
	}
	.nav-menu .w-clearfix{
	    max-width: 1280px;
	    margin:0 auto;
	}
	.nav-menu .logo{
	  margin: 0;
	}
	.nav-menu .languaje{
	    border: 1px solid #222;
        padding: 8px;
        font-size: 14px;
        border-radius: 3px;
	}
		.container-text{
	    padding:20px;
	}
</style>
<body class="body m6">
    <header class="text-gray-700 body-font nav-menu">
        <div class="w-clearfix w-col nav">
            <div class="item text-start">
                <a href="https://marivalvacationclub.com" class="logo">
                    <img src="https://marivalvacationclub.com/img/horizontal.svg" alt="Marival Vacation Club" class="logo" />
                </a>
             </div>
             
             <div class="item text-end">
                <a href="https://marivalvacationclub.com/es" class="languaje btn btn-primary">
                    ESPAÑOL
                </a>
            </div> 
        </div>
    </header>
	<div class="container container-text">
		<div class="row justify-content-center">
			<div class="col-md-12 col-lg-10">
					<h1 class="page-title">Identify Fake Vacation Offers </h1>
					<p>At Marival Vacation Club, your well-being and information security are our top priorities. Currently, some individuals on the internet, not legitimate agents of Marival Vacation Club, are offering fake deals. We have taken steps to protect you from these scams. </p>
					<p>Among our measures is this guide, which will help you recognize key signs of a scam. Review the following points and practice them for your protection. </p>

					<h2 class="section-title">How to Identify a Scam</h2>
					<p>1.- When making your reservation, you are likely dealing with a scam if a discounted price or free flight is promoted on platforms outside our websites, travel agencies, or authorized partners. To verify that Marival Vacation Club supports this service, consult our official channels, which include: </p>
					<ul>
						<li>Website: <a href="https://marivalvacationclub.com/">https://marivalvacationclub.com/</a> </li>
						<li>Reservations numbers: +1 510 270 0988</li>
						<li>New line for our Canadian members’ inquiries: (CAN) +1 343 643 1588 </li>
						<li>Email Marketing: noreply@marivalresorts.com, comunicados@marivalresorts.com.mx</li>
					</ul>
					<p>2.- Do not trust offers where the price is available for travel any time of the year without restrictions. At Marival Vacation Club, we control our availability and rates, which change according to the season. </p>
					<p>3.- If the offer is only for immediate purchase, meaning you cannot call back after reviewing your options, it is likely a scam. </p>
					<p>4.- Marival Vacation Club agents will never contact you via WhatsApp or text message (SMS). They will always call or email you to book your stay through our official toll-free numbers. </p>
					<p>5.- It is probably a scam if the agent or agency sends you copies of their IDs, accommodation contracts, or confirmation forms to imitate our documents. An authorized and established agency will offer confirmation directly from Marival Vacation Club. </p>
					<p>6.- Before making any payment, request the confirmation number and methods to verify the payment directly with our agents. Another way to verify the identity of the person offering you the package is to request proof of registration in the National Tourism Registry, where all tourism service providers in Mexico must register. You can also verify if it is an authorized agency by calling our direct numbers: </p>
					<ul>
						<li>Toll-free number MEX: 01 800 326 6600 </li>
						<li>Toll-free number USA and CAN: +1 888 270 4984 </li>
					</ul>
					<p>7.- Always ask your seller for a copy of the reservation details: reservation proof that contains the agency's stamp and letterhead with all your identification information, reservation number, hotel name, hotel address, room category, receipt covering the payment made, and information on how to contact Marival Vacation Club or Marival Resorts directly. </p>
					<p>8.- Avoid filling out forms on social media (Facebook or Instagram). This data can be used for fraudulent purposes or to contact you pretending to be an agent of Marival Vacation Club. </p>
					<p>9.- Book your stay on secure networks, never on open networks or public places like cafes, restaurants, airports, etc. </p>
					<p>10.- Install browser add-ons for secure web browsing whenever possible: Adware, Malware Bytes, etc. </p>
					<p>11.- Email addresses with the following domains are NOT part of the official communication channels of Marival Vacation Club: </p>
					<ul>
						<li>documentacionyservicios.com </li>
						<li>serviciosydocumentacion.com </li>
						<li>soporteydocumentacion.com </li>
						<li>memberservices@marivalinnovationclub.com</li>
						<li>promohotelesmexico.com</li>
						<li>reservasydocumentaciones.com</li>
					</ul>
					
					<p>12.- Any communication from the domain empiretitleescrow.com is NOT official nor related to Marival Vacation Club. </p>
					
					<p>We strongly advise you to disregard any communications from these accounts and report them to us to take the necessary precautions. </p>
					
					<p>Remember these tips when booking your stay. If you have any questions about our contact numbers or websites, use the ones provided in point 1 to communicate with us. </p>
                    <br/>
					<div class="alert alert-primary" role="alert">
						<h2 class="title">FRAUD NOTICE </h2>
						<p>Dear members, guests, and clients, please be aware that MARIVAL RESORTS, MARIVAL VACATION CLUB, and their affiliated companies have no commercial, contractual, or other relationship with the brand, agency, or website called FLY STAYS. MARIVAL RESORTS and MARIVAL VACATION CLUB have not granted licenses or rights to use their brands and logos to FLY STAYS or its related brands. Please ignore any information sent through FLY STAYS as a means of sale or contact for MARIVAL RESORTS and MARIVAL VACATION CLUB. </p>
						<p>We remind you of our official websites and phone numbers: <br/>
							https://marivalvacationclub.com/ <br/>
							Reservations USA & CAN:  +1 510 270 0988
						</p>
					</div>
			</div>
		</div>
	</div>
<footer>
    <div class="text-center contact-us-section">
        <h3>Contact us</h3>
        <br />
        <a href="tel:18778885828" class="nav-top-link">
            <span><i class="fas fa-phone"></i> Toll Free USA/CAN: </span> +1 510 270 0988 <br />
            <span><a href="mailto:info@marivalvacationclub.com">info@marivalvacationclub.com</a></span>
        </a>
      </div>
      <div class="text-center bg-gray-100 text-gray-900 direction-section">
        <div class="disclaimer">
          <a href="https://marivalvacationclub.com/privacy-notice" > Private Notice </a> | <a href="https://marivalvacationclub.com/cookie-policy" >“Cookie policy”</a>  | <a href="https://marivalvacationclub.com/fraud-notice"> How to Identify a Scam</a>
        </div>
        <br />
        <br />
        Blvd Paseo Cocoteros S/N Local #110, Nuevo Vallarta, Nayarit, 63735 México
        <br />
        © 2024 Marival Vacation Club. All Rights Reserved
      </div>
</footer> 
<script src="https://ajax.googleapis.com/ajax/libs/webfont/1.4.7/webfont.js" type="text/javascript" async></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html5shiv/3.7.3/html5shiv.min.js" type="text/javascript" async></script>
<script type="text/javascript" async>!function(o,c){var n=c.documentElement,t=" w-mod-";n.className+=t+"js",("ontouchstart"in o||o.DocumentTouch&&c instanceof DocumentTouch)&&(n.className+=t+"touch")}(window,document);</script>
<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.7.2/jquery.min.js"></script>

<script src="https://marivalvacationclub.com/js/app.js" async></script>
</body>
</html>